//
//  PlaygroundContextProtocol.swift
//  SPCLiveView
//
//  Created by Rob Rhyne on 5/18/20.
//  Copyright © 2020 Apple Computer. All rights reserved.
//

import UIKit
import SPCCore

public protocol PlaygroundContextProtocol {
    static var shared: PlaygroundContextProtocol       { get }
    static var liveViewController: LiveViewController  { get }
    
    var presentationMode: LiveViewContentPresentation  { get }
    var proxyClasses: [LiveViewRegistering.Type]       { get }
    var capabilities: [PlaygroundCapabilities]         { get }
}

public enum PlaygroundCapabilities {
    case lightSensor, toneSensor, toneOutput, backgroundMusic
}
